// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef INT_REAL_INC
#define INT_REAL_INC

#include "general.h"

namespace Torch {

/** This simple structure is used to sort data.
    #the_int# contains generally the index of a structured object,
    while #the_real# contains the value by which we wish
    to sort the objects.

    @author Samy Bengio (bengio@idiap.ch)
*/

struct Int_real {
  int the_int;
  real the_real;
};

struct real_real {
  real real1;
  real real2;
  real* p_real;
};

struct Int_char {
  int the_int;
  char *the_char;
};

/// this function returns 1 if p1->the_real > p2->the_real
extern "C" int compar_int_real(const void *p1, const void *p2);

/// this function returns 1 if p1 > p2
extern "C" int compar_real(const void *p1, const void *p2);

/// this function returns 1 if p1 > p2
extern "C" int compar_real_real(const void *p1, const void *p2);

/// this function returns 1 if p1->the_char > p2->the_char
extern "C" int compar_int_char(const void *p1, const void *p2);

}

#endif
