// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "SparseMatrixRW.h"
#include "DiskXFile.h"

namespace Torch
{

SparseMatrixRW::SparseMatrixRW():SparseMatrix()
{}

SparseMatrixRW::SparseMatrixRW(int nl_,int nc_):SparseMatrix(nl_,nc_)
{}

SparseMatrixRW::SparseMatrixRW(char *file)
{
	XFile *xfile=new(allocator)DiskXFile(file,"r");
	readXFile(xfile);
	allocator->free(xfile);	
}

SparseMatrixRW::SparseMatrixRW(XFile *xfile)
{
	readXFile(xfile);
}

void SparseMatrixRW::resize(int i, int size, bool preserve)
{
	lines[i].size=size;
	lines[i].frame=(sreal*)realloc(lines[i].frame,size*sizeof(sreal));
	if (!preserve)
		memset(lines[i].frame,0,size*sizeof(sreal));
}

void SparseMatrixRW::enforceSparsity(int i)
{
	int new_j=0;
	for (int j=0;j<lines[i].size;j++)
		if (lines[i].frame[j].value!=0)
		{
			if (new_j!=j) 
				memcpy(lines[i].frame+new_j,lines[i].frame+j,sizeof(sreal));
			new_j++;
		}
	lines[i].size=new_j;
	lines[i].frame=(sreal*)realloc(lines[i].frame,new_j*sizeof(sreal));
}

void SparseMatrixRW::readXFile(XFile *file)
{
	file->read(&nl,sizeof(int),1);
	file->read(&nc,sizeof(int),1);
	init();
	for (int i=0;i<nl;i++)
	{
		file->read(&(lines[i].size),sizeof(int),1);
		lines[i].frame=(sreal*)realloc(lines[i].frame,lines[i].size*sizeof(sreal));		
		file->read(lines[i].frame,sizeof(sreal),lines[i].size);
	}
}

SparseMatrixRW::~SparseMatrixRW() 
{
	for (int i=0;i<nl;i++)
		free(lines[i].frame);
}

}
