// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PASparseSupportSet.h"
#include "XFile.h"

namespace Torch {

PASparseSupportSet::PASparseSupportSet(int d) 
{
	sv_set = NULL;
	cur_sv = new (allocator) PASparseExample(d);
}

void PASparseSupportSet::set(int i)
{
	cur_alpha = alpha_set[i];
	((PASparseExample *)cur_sv)->vector = sv_set + i; 
}

void PASparseSupportSet::add(real alpha, PAExample *x)
{
	add(alpha, ((PASparseExample *)x)->vector);
}

void PASparseSupportSet::add(real alpha, svector *vector)
{
	size++;
	// copy alpha
	alpha_set = (real*) sv_allocator->realloc(alpha_set, sizeof(real) * size);
	alpha_set[size - 1] = alpha;
  // copy svector
	sv_set = (svector*) sv_allocator->realloc(sv_set, sizeof(svector) * size);	
	sv_set[size - 1].size = vector->size;
	sv_set[size - 1].frame = (sreal*) sv_allocator->alloc(sizeof(sreal) * vector->size);
	memcpy(sv_set[size - 1].frame, vector->frame, sizeof(sreal) * vector->size);
}

void PASparseSupportSet::empty()
{
	PASupportSet::empty();
	sv_set = NULL;
}

void PASparseSupportSet::saveXFile(XFile *file)
{
	// write set size
	file->write(&size, sizeof(int), 1); 
	// write alphas
	file->write(alpha_set, sizeof(real), size);
	// write vectors
	for (int i = 0; i < size; i++)
	{
		file->write(&(sv_set[i].size), sizeof(int), 1);
		file->write(sv_set[i].frame, sizeof(sreal), sv_set[i].size);
	}
}

void PASparseSupportSet::loadXFile(XFile *file)
{
	// empty previous set
	empty();                          
	// read set size
  file->read(&size, sizeof(int), 1);
	// read alphas
	alpha_set = (real*) sv_allocator->realloc(alpha_set, sizeof(real) * size);
	file->read(alpha_set, sizeof(real), size);  
	// read vectors
	sv_set = (svector*) sv_allocator->realloc(sv_set, sizeof(svector) * size);
	for (int i = 0; i < size; i++)
	{
		file->read(&(sv_set[i].size), sizeof(int), 1);
  	sv_set[i].frame = (sreal*) sv_allocator->alloc(sizeof(sreal) * sv_set[i].size);	
    file->read(sv_set[i].frame, sizeof(sreal), sv_set[i].size);
	}
}

PASparseSupportSet::~PASparseSupportSet() {}

}
