// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef DocumentFinder_INC
#define DocumentFinder_INC

#include "SparseMatrix.h"
#include "SVectorCalculator.h"

namespace Torch
{

class DocumentFinder : public Object 
{
	public:
	int n_doc;
	int *bin_scores;
	SparseMatrix *doc;
	SparseMatrix *tdoc;
	SVectorCalculator *calc;
	svector cur_list;

	DocumentFinder(SparseMatrix *doc_, SparseMatrix *tdoc_);
	
	// compute number of shared term with que for all docs 
	void binScoring(svector *query);

	// count number of doc such that bin_scores[d] = bin_score
	int countDoc(int bin_score);

	// return the list of docs s.t. bin_scores[d] = bin_score
	svector *getList(int bin_score);

	// pick one doc among those which bin_scores[d] = bin_score
	int uniformSampling(int bin_score);

	// sample a pair d^+, d^- where bin_score[d^+]=qlen and bin_score[d^-]=0
	void samplePair(svector *que, int *pos, int *neg);

	// compute dot product q.d
	real dotprod(svector *query, int d);

	virtual ~DocumentFinder(); 
};

}
#endif
