// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef SMatrixSplitter_INC
#define SMatrixSplitter_INC

#include "SparseMatrix.h"

namespace Torch {

class SMatrixSplitter : public Object
{
  public:
	int n;
	int nl;
	int nc;
	SparseMatrix *full_mat;
	SparseMatrix **sub_mat;
	SparseMatrix **index_mat;

	// -- constructor
	SMatrixSplitter();

	// -- split / join methods
	void split(char *full_mat_file, int n_);
	void join(char *sub_mat_file, int n_);	

	// -- sub methods
  void init(int n_, int nl_, int nc_);
	char* filename(char *file, char *ext, int i);
 
	// -- save methods
	void writeSplit(char *sub_mat_file);
	void writeJoin(char *full_mat_file);

	// -- destructor
	virtual ~SMatrixSplitter();
};

}
#endif
