// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef SMatrixCalculator_INC
#define SMatrixCalculator_INC

#include "SparseMatrix.h"
#include "XFile.h"

namespace Torch {

class SMatrixCalculator : public Object
{
	public:
	SparseMatrix *mat;
	real *idf;
	real *std;

	// constructor
	SMatrixCalculator(SparseMatrix *mat_);

	// meanLength
	real meanLength();

	// idf
	void computeIdf();
	void loadIdf(XFile *xfile);
  void saveIdf(XFile *xfile);

  // standard dev
  void computeStd();
  void loadStd(XFile *xfile);
  void saveStd(XFile *xfile);

	// matrix weighting 
	void okapiLocalWeight(float k, float b);
	void binaryWeight();
 	void xIdf();
	void l2Norm(real *norm);
	void l1Norm(real *norm);
	void scaleDoc(real *scaling);
	void varNorm();

	// destructor
	virtual ~SMatrixCalculator();
};

}
#endif
