// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PAKernelSparseLinear.h"

namespace Torch {

PAKernelSparseLinear::PAKernelSparseLinear() {}

real PAKernelSparseLinear::forward(PAExample *x, PAExample *y)
{
	return forward((PASparseExample*)x, (PASparseExample*)y);
}

real PAKernelSparseLinear::forward(PASparseExample *x, PASparseExample *y)
{
	int size_x = x->vector->size;
	int size_y = y->vector->size;

	// speedup when one of the vector is not sparse
	if ( size_x == x->size )
		return forwardFull(x, y);
	if ( size_y == y->size )
		return forwardFull(y, x); 

	real res = 0;
  sreal *f_x = x->vector->frame;
  sreal *f_y = y->vector->frame;
	sreal *last_x = f_x + size_x;
	sreal *last_y = f_y + size_y;

	while ((f_x != last_x)&&(f_y != last_y))	
	{
		if (f_x->index == f_y->index) 
		{
			res += f_x->value * f_y->value;
			f_x++;
			f_y++;
		}
		else
			if (f_x->index < f_y->index) 
			 f_x++; 
			else 
			 f_y++; 
	}	

	return res;
}

real PAKernelSparseLinear::forwardFull(PASparseExample *x, PASparseExample *y)
{
	real res = 0;

	int size_y = y->vector->size;
	sreal *f_x = x->vector->frame;
	sreal *f_y = y->vector->frame;
  sreal *last_y = f_y + size_y;

	while (f_y != last_y)
	{
		res += f_y->value * f_x[f_y->index].value;
		f_y++;
	}

	return res;
}

PAKernelSparseLinear::~PAKernelSparseLinear() {}

}
