// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PAIndexSupportSet.h"
#include "XFile.h"

namespace Torch {

PAIndexSupportSet::PAIndexSupportSet(int set_index_, int n_train_examples_)
{
	set_index = set_index_; 
	size = 0;
	sv_index = (sreal*) allocator->alloc(sizeof(sreal) * n_train_examples_);
	cur_sv = new (allocator) PAIndexExample();
}

void PAIndexSupportSet::empty()
{
	size = 0;
}

void PAIndexSupportSet::add(real alpha, PAExample *x)
{
	add(alpha, (PAIndexExample *)x);
}

void PAIndexSupportSet::add(real alpha, PAIndexExample *x)
{
  if (x->set_index!=set_index)
		error("You should add support vector from training set !");

	// add the vector, keeping the list sorted
	int sv = x->example_index;
	int i = 0;
	while ((i < size)&&(sv_index[i].index < sv)) i++;
	
	if (i == size) 
	{
		sv_index[i].index = sv;
		sv_index[i].value = alpha;
		size++;
	}
	else
		if (sv_index[i].index == sv)
			sv_index[i].value += alpha;
		else
		{
			memmove(sv_index + (i + 1), sv_index + i, sizeof(sreal) * (size - i));
	    sv_index[i].index = sv;
	    sv_index[i].value = alpha;
  	  size++;
		} 
}

void PAIndexSupportSet::set(int i)
{
	cur_alpha = sv_index[i].value;
	((PAIndexExample*)cur_sv)->set(set_index, sv_index[i].index);
}

void PAIndexSupportSet::loadXFile(XFile *file)
{
	file->read(&size, sizeof(int), 1);
	file->read(sv_index, sizeof(sreal), size);
}

void PAIndexSupportSet::saveXFile(XFile *file)
{
  file->write(&size, sizeof(int), 1);
  file->write(sv_index, sizeof(sreal), size);
}

PAIndexSupportSet::~PAIndexSupportSet()
{
}

}
