// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "ImgRtrvMeasurerFast.h"
#include "ImgConstraint.h"

namespace Torch {

ImgRtrvMeasurerFast::ImgRtrvMeasurerFast
 (PAMachine *machine_, SparseMatrix *queries_, 
	PADataset *images_, SparseMatrix *relevance_,
  XFile *out_)
:ImgRtrvMeasurer(machine_, queries_, images_, relevance_, out_)
{
	// allocate term_scores array
	n_term = queries->nc;
	real *ptr = (real*) allocator->alloc(sizeof(real) * n_term * n_img);
	term_scores = (real**) allocator->alloc(sizeof(real*) * n_term);
	for (int t = 0; t < n_term; t++)
		term_scores[t] = ptr + (t * n_img);
}

void ImgRtrvMeasurerFast::initMeasure()
{
	// allocate one term query
	svector term_que;
	sreal term;
	term_que.size = 1;
	term_que.frame = &term;
	term.value = 1.0;
	
	// get scores for each term
	for (int t = 0; t < n_term; t++)
	{
		term.index = t;
		ImgRtrvMeasurer::getQueryScores(&term_que);
		memcpy(term_scores[t], cur_que_scores, sizeof(real) * n_img);
	}
}

void ImgRtrvMeasurerFast::getQueryScores(svector *query)
{
	memset(cur_que_scores, 0, sizeof(real) * n_img);
	for (int t = 0; t < query->size; t++)
	{
		int tid = query->frame[t].index;
		real tval = query->frame[t].value;
		for (int i = 0; i < n_img; i++)
			cur_que_scores[i] += tval * term_scores[tid][i];
	}	
}

ImgRtrvMeasurerFast::~ImgRtrvMeasurerFast()
{}

}
