// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "SparseMatrixROM.h"
#include "DiskXFile.h"
namespace Torch
{

SparseMatrixROM::SparseMatrixROM(char *file)
{
	XFile *xfile=new(allocator)DiskXFile(file,"r");
	readXFile(xfile);
	allocator->free(xfile);
}

SparseMatrixROM::SparseMatrixROM(XFile *xfile)
{
  readXFile(xfile);
}

void SparseMatrixROM::init()
{
	error("Operation not permitted for read-only matrix");
}

void SparseMatrixROM::nullify(int i)
{
	error("Operation not permitted for read-only matrix");
}

void SparseMatrixROM::resize(int i, int size, bool preserve)
{
	error("Operation not permitted for read-only matrix");	
}

void SparseMatrixROM::copy(int i, svector *v)
{
	error("Operation not permitted for read-only matrix");
}

void SparseMatrixROM::enforceSparsity(int i)
{
	error("Operation not permitted for read-only matrix");
}

void SparseMatrixROM::readXFile(XFile *xfile)
{
	// size of the file
  xfile->seek(0, SEEK_END);
  long file_size=xfile->tell();
  xfile->rewind();
	// matrix dimension
	xfile->read(&nl,sizeof(int),1);
	xfile->read(&nc,sizeof(int),1);
	// read vectors
	file_size-=sizeof(int)*2;
	char *data=(char*)allocator->alloc(file_size);
  xfile->read(data,1,file_size);
	// structure vectors in lines
	lines=(svector*)allocator->alloc(sizeof(svector)*nl);
  memset(lines,0,sizeof(svector)*nl);
	int cur_pos=0;
	for (int i=0;i<nl;i++)
	{
		lines[i].size=*((int*)(data+cur_pos));
		cur_pos+=sizeof(int)/sizeof(char);
		lines[i].frame=(sreal*)(data+cur_pos);
		cur_pos+=lines[i].size*sizeof(sreal)/sizeof(char);
	}
}

SparseMatrixROM::~SparseMatrixROM() {}

}
