// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef PAMachineImageIR_INC
#define PAMachineImageIR_INC

#include "PAMachine.h"
#include "ImgConstraint.h"

namespace Torch
{

// important all term machines and the PAMachineImageIR 
// should have the SAME kernel !!!

class PAMachineImageIR : public PAMachine
{
	public:
	int n_term;
	PAMachine **term_machine;

	// constructor
	PAMachineImageIR(int n_term_, PAMachine **term_machine_);

	// initialize, i.e. empty the support_sets
	virtual void init();

	// forward
	virtual real forward(PAExample *x);
	virtual real forward(ImgConstraint *x);

	// add a support vector
	virtual void addSupport(real alpha, PAExample *x);
	void addSupport(real alpha, ImgConstraint *x);

  // k(x, x) 
  virtual real squareNorm(PAExample *x);
	real squareNorm(ImgConstraint *x);

  // load/save machine
  virtual void loadXFile(XFile *file);
  virtual void saveXFile(XFile *file);

	virtual ~PAMachineImageIR();
};

}
#endif
