// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "PAMachine.h"
#include "PAExample.h"

namespace Torch {

PAMachine::PAMachine()
{
	kernel = NULL;
	support_set = NULL;
}

PAMachine::PAMachine(PAKernel *kernel_, PASupportSet *support_set_)
{
  kernel = kernel_;
  support_set = support_set_;
}

void PAMachine::init()
{
	 support_set->empty();
}

real PAMachine::forward(PAExample *x)
{
	real res = 0;
	for (int i = 0; i < support_set->size; i++)
	{
		support_set->set(i);
		//		if (support_set->cur_alpha != 0)
		res += support_set->cur_alpha * kernel->forward(support_set->cur_sv, x);
	}
	return res;
}

void PAMachine::addSupport(real alpha, PAExample *x)
{
	support_set->add(alpha, x);
}

real PAMachine::squareNorm(PAExample *x)
{
	return kernel->forward(x, x);
}

void PAMachine::loadXFile(XFile *file)
{
	support_set->loadXFile(file);
}

void PAMachine::saveXFile(XFile *file)
{
	support_set->saveXFile(file);
}

PAMachine::~PAMachine() {}

}
