// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "Links.h"
#include "Random.h"

namespace Torch
{

Links::Links(char *file):SparseMatrixROM(file)
{}

Links::Links(XFile *xfile):SparseMatrixROM(xfile)
{}

void Links::sampleTriplet(int *q, int *dp, int *dn)
{
	// pick q (with at least 1 link)
	int npos=0;
	while (npos < 1)
	{
		*q = Random::random() % nl;
		npos = lines[*q].size;
	}

	// pick dp 
	int p = Random::random() % npos;     // 1 among npos doc
	*dp = lines[*q].frame[p].index;

	// pick dn
	int n = Random::random() % (nc-npos); // 1 among (nc - npos) doc
	int pos_i = 0;  // then find the index of the n th neg doc (all doc which are not pos are neg) 
	while ((pos_i<npos)&&( lines[*q].frame[pos_i].index - (pos_i+1) < n ) )
		pos_i++;
	*dn = (n + pos_i);
}

Links::~Links()
{}

}
