// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "ImgRtrvMeasurerScores.h"

namespace Torch {

ImgRtrvMeasurerScores::ImgRtrvMeasurerScores
 (PAMachine *machine_, SparseMatrix *queries_, 
	PADataset *images_, int n_img_, XFile *out_)
:ImgRtrvMeasurerFast(machine_, queries_, images_, NULL, out_)
{
}

void ImgRtrvMeasurerScores::measure()
{
	message("ImgRtrvMeasurerScores::measure");
  initMeasure();
  for (int q = 0; q < n_que; q++)
  {
    getQueryScores(queries->lines + q);
		for (int i = 0; i < n_img; i++)
			out->printf("%f ", cur_que_scores[i]);
		out->printf("\n");
  }
}


ImgRtrvMeasurerScores::~ImgRtrvMeasurerScores()
{}

}
