// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef ImgConstraintDataset_INC
#define ImgConstraintDataset_INC

#include "PADataset.h"
#include "SparseMatrix.h"

namespace Torch
{

class MarginPolicy;
class WeightPolicy;

class ImgConstraintDataset : public PADataset
{
  public:
	// size & shuffle
	int n_que;
  int *que_shuffle;
	// current indexes
	int cur_que_s;
	int cur_que;
	int cur_pos;
	int cur_neg;
	// policies
	MarginPolicy *margin;
	WeightPolicy *weight;
	// data
	SparseMatrix *queries;
	SparseMatrix *relevance;
	PADataset *images;

  ImgConstraintDataset(SparseMatrix *queries_,  
                       SparseMatrix *relevance_, 
											 PADataset *images_,
											 MarginPolicy *margin_ = NULL,
											 WeightPolicy *weight_ = NULL); 

	virtual void init();
  virtual PAExample *nextExample();

	virtual void sampleImg(svector *rel);

  virtual ~ImgConstraintDataset();
};

}
#endif
