// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "sreal.h"

namespace Torch 
{

 //compare 2 sreal using their index, return 1 if arg1>arg2
  int sreal_comp_index(const void *arg1, const void *arg2)
  {
    if (((sreal*) arg1)->index == ((sreal*) arg2)->index) {return 0;}
    else 
      {
	if (((sreal*) arg1)->index > ((sreal*) arg2)->index) {return 1;} else {return -1;}
      }
  }

  //compare 2 sreal using their value /!\ return -1 if arg1>arg2
  int sreal_comp_values(const void *arg1, const void *arg2)
  {
    if (((sreal*) arg1)->value == ((sreal*) arg2)->value) {return 0;}
    else 
      {
	if (((sreal*) arg1)->value > ((sreal*) arg2)->value) {return -1;} else {return 1;}
      }
  }

  //compare 2 sreal using their value /!\ return +1 if arg1>arg2
  int sreal_comp_values_ascend(const void *arg1, const void *arg2)
  {
    if (((sreal*) arg1)->value == ((sreal*) arg2)->value) {return 0;}
    else
      {
  	if (((sreal*) arg1)->value > ((sreal*) arg2)->value) {return 1;} else {return -1;}
      }
  }

	int sreal_comp_abs_values_descend(const void *arg1, const void *arg2)
  {
    if (((sreal*) arg1)->value == ((sreal*) arg2)->value) {return 0;}
    else
      {
  if (fabs(((sreal*) arg1)->value) > fabs(((sreal*) arg2)->value)) {return -1;} else {return 1;}
      }
  }

}
