// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


// Read/Write sparse matrix WITHOUT using allocator for lines which is a SPEED UP trick

#ifndef SparseMatrixRW_INC
#define SparseMatrixRW_INC

#include "general.h"
#include "Object.h"
#include "sreal.h"
#include "XFile.h"
#include "SparseMatrix.h"

namespace Torch
{

class SparseMatrixRW:public SparseMatrix
{
	public:
	// --- constructors ---
	SparseMatrixRW();

	// new null matrix
	SparseMatrixRW(int nl_,int nc_); 

	// read from file
  SparseMatrixRW(char *file);
  SparseMatrixRW(XFile *xfile);
	
	// ----

	// resize line i
	virtual void resize(int i, int size, bool preserve=false);

	// enforce sparsity for line i
	virtual void enforceSparsity(int i);

	// read file
	virtual void readXFile(XFile *file);

	virtual ~SparseMatrixRW();
};

}
#endif
