// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#include "NearestNeighbors.h"
#include "SVectorCalculator.h"

namespace Torch
{

NearestNeighbors::NearestNeighbors(SparseMatrix *q, SparseMatrix *d, int n)
:SparseMatrixRW(q->nl,d->nl)
{
	SVectorCalculator* c=new(allocator)SVectorCalculator(q->nc);

	svector *cur_score=(svector*)allocator->alloc(sizeof(svector));
	cur_score->frame=(sreal*)allocator->alloc(sizeof(sreal) * d->nl);
	
  for (int iq=0;iq<q->nl;iq++)
	{
		// init
		cur_score->size = d->nl;
		memset(cur_score->frame, 0, sizeof(sreal) * d->nl);	
		// compute all scores
		for (int id=0;id<d->nl;id++)
		{	
			cur_score->frame[id].index = id;
			cur_score->frame[id].value = c->inner(q->lines + iq, d->lines + id);
		}
		// keep n best
		qsort(cur_score->frame, d->nl, sizeof(sreal), sreal_comp_values);			
		int i = n-1;
		while ((i>=0)&&(cur_score->frame[i].value==0))	i--;
		cur_score->size = i+1;
		qsort(cur_score->frame, cur_score->size, sizeof(sreal), sreal_comp_index);
		// put them in matrix
		copy(iq, cur_score);	
	}

	allocator->free(c);
	allocator->free(cur_score->frame);
	allocator->free(cur_score);
}

NearestNeighbors::~NearestNeighbors() {}

}
