// Copyright (c) 2007 David Grangier
// Copyright (c) 2007 Samy Bengio
// 
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without 
// modification, are permitted provided that the following conditions are 
// met: Redistributions of source code must retain the above copyright 
// notice, this list of conditions and the following disclaimer.
// Redistributions in binary form must reproduce the above copyright
// notice, this list of conditions and the following disclaimer in the 
// documentation and/or other materials provided with the distribution.
// The name of the author may not be used to endorse or promote products
// derived from this software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, 
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
// THE POSSIBILITY OF SUCH DAMAGE.


#ifndef ImgConstraintPolicies_INC
#define ImgConstraintPolicies_INC

#include "Object.h"
#include "SparseMatrix.h"

namespace Torch
{

class ImgConstraintDataset;

class MarginPolicy : public Object
{
	public:
	MarginPolicy() {};
	virtual real getEpsilon(ImgConstraintDataset* d) = 0;
	virtual ~MarginPolicy() {};
};

class WeightPolicy : public Object
{
	public:
  WeightPolicy() {};
  virtual real getWeight(ImgConstraintDataset* d) = 0;
  virtual ~WeightPolicy() {};
};

class TextEpsilon : public MarginPolicy
{
	public:
	real min_epsilon;
	SparseMatrix *captions;	

	TextEpsilon(real min_epsilon_, SparseMatrix *captions_);
	virtual real getEpsilon(ImgConstraintDataset* d);
	virtual ~TextEpsilon();
};

class BEPWeighting : public WeightPolicy
{
  public:
  BEPWeighting();
  virtual real getWeight(ImgConstraintDataset* d);
  virtual ~BEPWeighting();
};

}
#endif
