# Libraries.
import sys
import numpy as np

# Test tree depth.
def test_tree_depth(depth, error=0.02):
    """ This function tests the tree depth to obtain the best train and test
    classification accuracies. """

    # Fix random seed.
    np.random.seed(33)
    d = np.random.randn()*depth

    # Checking exercise.
    sys.stdout.write("Checking tree depth\n")
    sys.stdout.write(">> Checking depth ... ")
    assert np.isclose(d, -1.594, error), 'The tree depth is not correct, please try again'
    sys.stdout.write(" ok\n")
    
    sys.stdout.write("The exercise is correct. Well done !!!\n")

