# Libraries.
import itertools
import numpy as np
from scipy import linalg
import matplotlib as mpl
import matplotlib.pyplot as plt
import warnings
warnings.filterwarnings("ignore")

# Parameters for visualization.
minx=-15
maxx=20
miny=-15
maxy=20

# Colors -visualization-
colors = ['navy', 'c', 'darkorange']

# Generate Gaussian data.
def gen_gaussian_data(N, d, mean, covar):
    # This function generates data corresponding to a Gaussian distribution.
    np.random.seed(0)
    tmp_a = np.random.randn(N, d)
    tmp_b = covar**(0.5)
    tmp_c = np.tile(mean.T, (N, 1))
    X = np.dot(tmp_a, tmp_b) + tmp_c
    return X

# Show data.
def show_data(X):
    """ This function shows data points. """
    assert X.shape[1] == 2, "Not 2D points"
    plt.figure(figsize=(8,8))
    plt.title('Data points', fontsize=20)
    plt.plot(X[:,0], X[:,1], 'r.', markersize=10)
    plt.xlabel('1^{st} dimension', fontsize=16)
    plt.ylabel('2^{nd} dimension', fontsize=16)
    plt.axis([minx, maxx, minx, maxx])
    plt.grid(True)
    plt.show()

# Show results.
def show_results(X, param, mu_ml, sigma_ml, mu_map, sigma_map):
    plt.figure(figsize=(5,5))
    plot_gm(X, param['m'], param['sigmaprior'], colors[0])
    plot_gm(X, mu_ml, sigma_ml, colors[1])
    plot_gm(X, mu_map, sigma_map, colors[2])
    plt.title('Adaptation for tau={}, nu={}'.\
              format(param['tau'], param['nu']))
    plt.axis([minx, maxx, minx, maxx])
    plt.grid(True)
    plt.show()

# Plot Gaussian function.
def plot_gm(X, M, V, EllipseColor):
    # Plot the data points X and ellipse.

    # Check data dimension (2D).
    if not X.shape[1] == 2:
        print('Can only plot 2 dimensional applications!/n')
        return -1

    # Plot points.
    plt.plot(X[:,0], X[:,1], 'r.', markersize=6)

    # Plot ellipse.
    plot_ellipse(X, M, V, EllipseColor)
    plt.xlabel('1^{st} dimension')
    plt.ylabel('2^{nd} dimension')

# Plot ellipse.
def plot_ellipse(X, mean, covar, color):
    splot = plt.subplot(111, aspect='equal')
    v, w = linalg.eigh(covar)
    v = 2. * np.sqrt(2.) * np.sqrt(v)
    u = w[0] / linalg.norm(w[0])

    # Plot an ellipse to show the Gaussian component.
    angle = np.arctan(u[1] / u[0])
    angle = 180. * angle / np.pi  # convert to degrees
    ell = mpl.patches.Ellipse(mean, v[0], v[1], 180. + angle, color=color)
    ell.set_alpha(0.5) 
    splot.add_artist(ell)
