# Libraries.
import sys
import numpy as np
from numpy import random as rnd

# Test linear regression.
def test_linear_regression(l_regression):
    """ This function tests the implementation to load the synthetic
    dataset."""

    # Random seed.
    np.random.seed(0)

    # Generate samples (x, y) following
    # a step function.
    x = np.random.rand(100)
    y = np.zeros_like(x)
    y[x>=0.6] = 1.0
    data = {'x':x, 'y':y}

    sys.stdout.write("Checking exercise\n")
    sys.stdout.write(">> Run test 1 ... ")
    model, pred = l_regression(data, data, degree=5)
    sum_pred = np.sum(pred['test'])
    assert np.isclose(sum_pred, 38.0, 0.001), 'The sum of prediction values should return %s, but returned %s\n' % (str(38.0), str(sum_pred))
    sys.stdout.write(" ok\n")

    # Generate samples (x, y) following
    # a step function.
    x = np.random.rand(100)
    y = np.zeros_like(x)
    y[x>=0.3] = 1.0
    data = {'x':x, 'y':y}

    model, pred = l_regression(data, data, degree=9)
    sys.stdout.write(">> Run test 2 ... ")
    sum_pred = np.sum(pred['test'])
    assert np.isclose(sum_pred, 73.0, 0.001), 'The sum of prediction sum should return %s, but returned %s\n' % (str(73.0), str(sum_pred))
    sys.stdout.write(" ok\n")

    sys.stdout.write("The exercise is correct. Well done !!!\n")
    
# Test RMSE.
def test_compute_rmse(rmse_fun):
    """ This function tests the implementation to compute rmse. """ 

    y_gt = np.array([1.0, 0.5, 0.1, 0.4, 0.0])
    y_pred = np.array([0.3, 0.5, 0.3, 0.1, 0.1])
    rmse = rmse_fun(y_gt, y_pred)

    sys.stdout.write("Checking exercise\n")
    sys.stdout.write(">> Check float ... ")
    assert isinstance(rmse, float), 'RMSE size should be float'
    sys.stdout.write(" ok\n")

    sys.stdout.write(">> Run test  ... ")
    assert np.isclose(rmse, 0.3549, 0.001), 'RMSE should return %s, but returned %s\n' % (str(0.3549), str(rmse))
    sys.stdout.write(" ok\n")

    sys.stdout.write("The exercise is correct. Well done !!!\n")
    
